(function(_window, _logLevel, _utils) {
    'use strict';

    var DEFAULT_LEVEL = 5,
        logLevel = _utils.isInteger(_logLevel) ? _logLevel : DEFAULT_LEVEL,
        log = {
            ALL: 0,
            MAX_LOGS: 1,
            VERBOSE: 2,
            DEBUG: 3,
            INFO: 4,
            WARN: 5,
            ERROR: 6,
            ASSERT: 7,

            shouldLog: function(level) {
                return logLevel <= level;
            }
        };

    log.v = (logLevel <= log.VERBOSE) ? Function.prototype.bind.call(console.log, console) : _utils.noop;
    log.d = (logLevel <= log.DEBUG) ? Function.prototype.bind.call(console.log, console) : _utils.noop;
    log.i = (logLevel <= log.INFO) ? Function.prototype.bind.call(console.log, console) : _utils.noop;
    log.w = (logLevel <= log.WARN) ? Function.prototype.bind.call(console.warn, console) : _utils.noop;
    log.e = (logLevel <= log.ERROR) ? Function.prototype.bind.call(console.error, console) : _utils.noop;

    _window.log = log;
})(window, window.logLevel, window.utils);
